#ifndef __BOOTPHEADER_H_
#define __BOOTPHEADER_H_

#include "utils.h"

#pragma pack(push, 1)
struct _bootp_header
{
  u_char	op;  // 1 - request, 2 - reply
  u_char	htype; // 1 ethernet
  u_char	hlen; 
  u_char	hops;
  u_long	xid;
  u_short	secs;
  u_short unused;
  u_char	ciaddr[4];
  u_char	yiaddr[4];
  u_char	siaddr[4];
  u_char	giaddr[4];
  u_char	chaddr[16];
  u_char	sname[64];
  u_char	file[128];
  u_char	vend[64];
};
#pragma pack(pop)

#define BOOTP_HEADER_SIZE sizeof(_bootp_header)
#define BOOTP_OP_REQUEST 1
#define BOOTP_OP_REPLY 2
#define BOOTP_HTYPE_ETHERNET 1
#define SERVICE_BOOTPS  67          // RFC951 (server)
#define SERVICE_BOOTPC  68          //        (client)



class BOOTPHeader
{
public:
  BOOTPHeader(u_char _op, u_long _xid, u_char* _srcMAC);
  BOOTPHeader(const u_char* _data);
  void setMem(u_char* _data);
  void dump( void );

  const u_char Opcode() const;
  const u_long XID() const;
  const u_char *YourIP() const;
  const u_char *ServerIP() const;
  const u_char *GatewayIP() const;

private:
  _bootp_header data;

  void data2host(void);
  void data2network(void);
};

#endif